VERSION 5.00
Object = "{5DA62B65-0D48-11D2-A6E3-00400541EFEE}#1.0#0"; "SvcIt.ocx"
Begin VB.Form Main 
   Caption         =   "Active+ Demo Service"
   ClientHeight    =   2025
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4230
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2025
   ScaleWidth      =   4230
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer Timer1 
      Interval        =   1000
      Left            =   960
      Top             =   1320
   End
   Begin VB.TextBox State 
      Height          =   315
      Left            =   1320
      TabIndex        =   3
      Top             =   120
      Width           =   2745
   End
   Begin VB.CommandButton LogEventBtn 
      Caption         =   "LogEvent"
      Height          =   345
      Left            =   2760
      TabIndex        =   1
      Top             =   1440
      Width           =   1245
   End
   Begin SVCITLib.SvcIt MyService 
      Height          =   480
      Left            =   210
      TabIndex        =   0
      ToolTipText     =   "Right-Click here to debug"
      Top             =   1290
      Width           =   480
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      ServiceName     =   "ActivePlusDemo"
      DisplayName     =   "Active+ Demo (ServiceMill Control)"
      Description     =   "ServiceMill Control Demo Service from Active+ Software"
      Dependencies    =   ""
      MachineName     =   ""
      ServiceExe      =   ""
      PauseContinue   =   -1  'True
      Priority        =   1
   End
   Begin VB.Label Info 
      Alignment       =   2  'Center
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1680
      TabIndex        =   5
      Top             =   1440
      Width           =   615
   End
   Begin VB.Label Label2 
      Caption         =   "At design time you can right-click over the control to simulate the service manager (Start, Stop, etc.)"
      Height          =   495
      Left            =   120
      TabIndex        =   4
      Top             =   720
      Width           =   3975
   End
   Begin VB.Label Label1 
      Caption         =   "Service state:"
      Height          =   255
      Left            =   150
      TabIndex        =   2
      Top             =   180
      Width           =   1095
   End
End
Attribute VB_Name = "Main"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim iInfo As Integer

Private Sub Form_Load()
  MyService.PauseContinue = True
  
  ' Parse startup parameters
  Dim argv() As String, arg As Variant
  argv = Split(Command(), "/", -1, vbTextCompare)
  For Each arg In argv
    Select Case LCase(arg)
      Case "install" ' Install the service into the service manager database
        MyService.Mode = 2 ' Admin mode
        ' Remove any previously installed service
        If MyService.IsInstalled Then MyService.Remove
        ' This method can only be called when the program is complied into a .exe
        MyService.Install False
        Dim iResult As Integer
        iResult = MsgBox("The service " & MyService.DisplayName & " is now installed" & vbCrLf & "Press OK to start the service", vbOKCancel)
        If iResult = vbOK Then MyService.Start ("Hello World!")
        End
      Case "remove" ' Remove the service from the service manager database
        MyService.Mode = 2 ' Admin mode
        MyService.Remove
        MsgBox "The service " & MyService.DisplayName & " has been removed"
        End
    End Select
  Next
  
  If Not MyService.IsInstalled Then
    MsgBox "To start this program as a service, make the program into an executable and run service.exe /install"
  End If
  
  If Not MyService.IsService Then
    ' Uncomment the following line to simulate a service start to avoid right-clicking on the control each time you start the app at design time
    ' MyService.Start ""
  End If
End Sub

Private Sub LogEventBtn_Click()
  MyService.LogEvent "Error message!", 1
End Sub

Private Sub MyService_Continue()
  State.Text = "Started"
End Sub

Private Sub MyService_Control(ByVal Code As Long)
  State.Text = "Control(" + LTrim$(Str$(Code)) + ")"
End Sub

Private Sub MyService_Logoff()
  State.Text = "Logoff"
  MyService.LogEvent "The user is logging off.", 4
End Sub

Private Sub MyService_ReceiveData(vData As Variant, vResult As Variant)
    Dim i, s
    If IsArray(vData) Then
        For i = LBound(vData) To UBound(vData)
            If Not IsEmpty(vData(i)) Then
                s = s + CStr(vData(i)) & "-"
            End If
        Next
    Else
        s = CStr(vData)
    End If
    State.Text = "Data=" & s
    vResult = "Thanks I got your data!"
End Sub

Private Sub MyService_Pause()
  State.Text = "Paused"
End Sub

Private Sub MyService_Start(ByVal sParams As String)
  If sParams = "" Then
    State.Text = "Started"
  Else
    State.Text = "Started Params=" + sParams
  End If
  
  Rem If your initialization process fails, you
  Rem can abort the service startup by calling the
  Rem Abort(Error, SpecificError) method
  Rem followed by the End Statement
  Rem Example:
  Rem MyService.Abort 0, 1
  Rem End
  
  MyService.LogEvent "The service was successfully started.", 4
End Sub

Private Sub MyService_Stop()
  State.Text = "Stopped"
  MyService.LogEvent "The service was stopped.", 4
End

End Sub

Private Sub Timer1_Timer()
  If MyService.IsRunning() Then
    iInfo = iInfo + 1
    If iInfo > 10 Then iInfo = 1
    Info.Caption = iInfo
    Open "c:\temp\prout.txt" For Output Shared As #1
    Write #1, FormatDateTime(Date, vbShortDate)
    Close #1
  End If
End Sub
