unit Servicemain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, OleCtrls, SVCITLib_TLB;

type
  TMain = class(TForm)
    MyService: TSvcIt;
    Label1: TLabel;
    State: TEdit;
    Label2: TLabel;
    LogEventBtn: TButton;
    Info: TLabel;
    Timer1: TTimer;
    procedure LogEventBtnClick(Sender: TObject);
    procedure MyServiceContinue(Sender: TObject);
    procedure MyServiceControl(Sender: TObject; Code: Integer);
    procedure MyServiceLogoff(Sender: TObject);
    procedure MyServicePause(Sender: TObject);
    procedure MyServiceStart(Sender: TObject; const sParams: WideString);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    iInfo: integer;
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

{$R *.dfm}

procedure TMain.LogEventBtnClick(Sender: TObject);
begin
 MyService.LogEvent('Error message!', 1);
end;

procedure TMain.MyServiceContinue(Sender: TObject);
begin
 State.Text := 'Started';
end;

procedure TMain.MyServiceControl(Sender: TObject; Code: Integer);
begin
  State.Text := 'Control(' + Trim(IntToStr(Code)) + ')';
end;

procedure TMain.MyServiceLogoff(Sender: TObject);
begin
 State.Text := 'Logoff';
 MyService.LogEvent('The user is logging off.', 4);
end;

procedure TMain.MyServicePause(Sender: TObject);
begin
 State.Text := 'Paused';
end;

procedure TMain.MyServiceStart(Sender: TObject; const sParams: WideString);
begin
 if sParams = '' then
  State.Text := 'Started'
 else
  State.Text := 'Started Params=' + sParams;

  {
   if your initialization process fails, you can abort the service startup by
   calling the Abort(Error, SpecificError) method followed by the End Statement
   Example:
   MyService.Abort(0, 1);
  }

  MyService.LogEvent('The service was stopped.', 4);
end;

procedure TMain.Timer1Timer(Sender: TObject);
begin
 if MyService.IsRunning then begin
   iInfo := iInfo + 1;
   if iInfo > 10 then iInfo := 1;
   Info.Caption := IntToStr(iInfo);
 end;
end;

procedure TMain.FormCreate(Sender: TObject);
var
 i,pt: integer;
 s,msg: string;
begin
 MyService.PauseContinue := True;


 if (ParamCount>0) then begin
   for i := 1 to ParamCount do begin
     s := ParamStr(i);
     s := lowercase(Copy(s, 2, (Length(s)-1)));

     if (s='install') then pt := 0;
     if (s='remove') then pt := 1;

     case pt of
      0: begin
       MyService.Mode := 2; //Admin mode
       //Remove any previously installed service
       if MyService.IsInstalled then
         MyService.Remove;
       //This method can only be called when the program is compiled into an .exe
       MyService.Install(False);

       msg := 'The service ' + MyService.DisplayName + ' is now installed' + #13#10 +
              'Press Ok to start the service';

       if (MessageDlg( PChar(msg), mtConfirmation, [mbYes, mbNo], 0) = mrYes) then
        MyService.Start('Hello World!');

       end;
      1: begin

          MyService.Mode := 2;
          if MyService.IsInstalled then begin
            MyService.Remove;

           msg := 'The service ' + MyService.DisplayName + ' has been removed';

           MessageDlg( PChar(msg), mtInformation, [mbOk], 0);
          end;

        end;
     end;

   end;

 end;

   if not MyService.IsInstalled then begin
     msg := 'To start this program as a service, make the program into an executable and run Service.exe /install';

     MessageDlg( PChar(msg), mtInformation, [mbOk], 0);
     Main.Hide;
     Application.Terminate;
   end;

   if not MyService.IsService then begin
    //Uncomment the following line to simulate a service start to avoid right-clicking on the control each time you start the app at design time
    // MyService.Start('');
     Main.Hide;
     Application.Terminate;
   end;


end;

end.
